require 'rubygems'
require 'mongo'
require 'time'
include Mongo

@mongo_client = MongoClient.new("localhost", 27017);
#@mongo_client = MongoClient.new("172.16.45.58", 27017);

def assessment_history(patientId, updateDate, admittedDateTime)
    assessmentHistory = {
        'patientIdentifier' => patientId,
        'createDatetime' => updateDate,
        'updateDatetime' => updateDate,
        'admittedDateTime' => admittedDateTime,
        'status' => 'SAVED',
        'bradenAssessment' => {
            'createDatetime' => updateDate,
            'updateDatetime' => updateDate,
            #'sensoryPerception' => 3,
            #'moisture' => 2,
            #'activity' => 3,
            #'mobility' => 1,
            #'nutrition' => 4,
            #'frictionAndShear' => 1,
            'sensoryPerception' => (rand(4)+1),
            'moisture' => (rand(4)+1),
            'activity' => (rand(4)+1),
            'mobility' => (rand(4)+1),
            'nutrition' => (rand(4)+1),
            'frictionAndShear' => (rand(3)+1),
            'status' => 'SAVED'
        },
        'skinInspection' => {
            'allAreasAssessed' => true,
            'skinPatches' => 'Yes',
            'skinColor' => 'Pale',
            'skinTemperature' => 'Hot',
            'skinTemperatureComment' => 'EN FUEGO!',
            'skinMoisture' => 'Moist',
            'skinMoistureComment' => 'Very Moist.',
            'skinTurgor' => 'Within Normal Limits',
            'skinTurgorComment' => 'Thank goodness',
            'skinProblems' => %w(Burn Rash),
            'skinProblemsComment' => 'At least there is no Abrasion!',
            'ulcerPresent' => 'Yes',
            'status' => 'SAVED'
        },
        'riskFactorAssessment' => {
            'createDatetime' => updateDate,
            'updateDatetime' => updateDate,
            'status' => 'SAVED',
            'alterationsInSensation' => [],
            'alterationsInMobility' => [],
            'frictionOrShear' => [],
            'alterationInNutritionOrHydration' => [],
            'moisture' => [],
            'otherDiagnoses' => [] 
        },
        'education' => {
            'createDatetime' => updateDate,
            'updateDatetime' => updateDate,
            'status'=> 'SAVED',
            'abilityToComprehend'=> {},
            'desireToLearn'=> {},
            'importanceOfNutritionEtc'=> {},
            'pressureUlcer'=> {},
            'preventativeSkinCare'=> {},
            'printedEducationMaterial'=> {},
            'responseToEducation'=> {},
            'riskFactors'=> {},
            'roleOfVeteran'=> {},
            'routineSkinInspection'=> {},
            'treatmentPlan'=> {},
            'ulcerManagement'=> {}
        }
    }
    return assessmentHistory;
  end

  def set_risk_education(assessmentHistory, updateDate, step) 
    datetime = updateDate - (60 * 60 * 24 * step)
    assessmentHistory['riskFactorAssessment']['alterationsInSensation'].push({'value' => 'Diabetes Mellitus', 'datetime'=> datetime})
    assessmentHistory['riskFactorAssessment']['alterationsInSensation'].push({'value' =>'CVA', 'datetime'=> datetime})
    assessmentHistory['riskFactorAssessment']['alterationsInMobility'].push({'value' => 'Fracture Amputation', 'datetime'=> datetime})
    assessmentHistory['education']['abilityToComprehend']['patient'] = {'value'=> 1,'datetime'=> datetime}
    assessmentHistory['education']['abilityToComprehend']['caregiver'] = {'value'=> 1,'datetime'=> datetime}
    assessmentHistory['education']['desireToLearn']['patient'] = {'value'=> 1,'datetime'=> datetime}
    assessmentHistory['education']['desireToLearn']['caregiver'] = {'value'=> 1,'datetime'=> datetime}
    if step > 1 then
        datetime = datetime + (60 * 60 * 24 * 1)
        assessmentHistory['riskFactorAssessment']['frictionOrShear'].push({'value' => 'Poor posture', 'datetime'=> datetime})
        assessmentHistory['riskFactorAssessment']['frictionOrShear'].push({'value' =>'Spasticity', 'datetime'=> datetime})
        assessmentHistory['riskFactorAssessment']['alterationInNutritionOrHydration'].push({'value' => 'Increase or decrease in weight', 'datetime'=> datetime})
        assessmentHistory['education']['importanceOfNutritionEtc']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['importanceOfNutritionEtc']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['pressureUlcer']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['pressureUlcer']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['preventativeSkinCare']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['preventativeSkinCare']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['printedEducationMaterial']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
        assessmentHistory['education']['printedEducationMaterial']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}    
        if step > 2 then
            datetime = datetime + (60 * 60 * 24 * 1)    
            assessmentHistory['riskFactorAssessment']['moisture'].push({'value' => 'Edema', 'datetime'=> datetime})
            assessmentHistory['riskFactorAssessment']['otherDiagnoses'].push({'value' => 'CHF', 'datetime'=> datetime})
            assessmentHistory['riskFactorAssessment']['otherDiagnoses'].push({'value' => 'PVD', 'datetime'=> datetime})
            assessmentHistory['education']['responseToEducation']['patient'] = {'value'=> 1,'datetime'=> datetime}
            assessmentHistory['education']['responseToEducation']['caregiver'] = {'value'=> 1,'datetime'=> datetime}
            assessmentHistory['education']['riskFactors']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['riskFactors']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['roleOfVeteran']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['roleOfVeteran']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['routineSkinInspection']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['routineSkinInspection']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['treatmentPlan']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['treatmentPlan']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['ulcerManagement']['patient'] = {'value'=> 'Yes','datetime'=> datetime}
            assessmentHistory['education']['ulcerManagement']['caregiver'] = {'value'=> 'Yes','datetime'=> datetime}
        end
    end
    return assessmentHistory
  end  

  def clear_and_generate_mongo_data_for_inpatient_eighty
    patientId = {'assigningAuthority' => 'dfn-777', 'patientId' => '100788'}
    prevAdmittedDateTime = Time.strptime('12/05/2008 10:24:32', '%m/%d/%Y %H:%M:%S');
    admittedDateTime = Time.strptime('01/05/2009 10:24:32', '%m/%d/%Y %H:%M:%S');

    skincheck_db = @mongo_client['skincheck']
    skin_assessment_coll = skincheck_db['skinAssessment']
    skin_assessment_coll.remove(:patientIdentifier => patientId)
    now = Time.now
    for day in 3..5 do
      updateDate = prevAdmittedDateTime + (60 * 60 * 24 * day)
      assessmentHistory = assessment_history(patientId, updateDate, prevAdmittedDateTime)
      assessmentHistory = set_risk_education(assessmentHistory, updateDate, 3)
      skin_assessment_coll.insert(assessmentHistory)
    end
    for day in 1..2 do
      updateDate = admittedDateTime + (60 * 60 * 24 * day)
      assessmentHistory = assessment_history(patientId, updateDate, admittedDateTime)
      assessmentHistory = set_risk_education(assessmentHistory, updateDate, day)
      skin_assessment_coll.insert(assessmentHistory)
    end

    skin_assessment_coll.find(:patientIdentifier => patientId).each { |doc|
      puts "inserted: #{doc}"
    }
  end

  def clear_and_generate_mongo_data_for_graphing_patient_one
    patientId = {'assigningAuthority' => 'dfn-777', 'patientId' => '100839'}
    prevAdmittedDateTime = Time.strptime('2/05/2010 12:00:00', '%m/%d/%Y %H:%M:%S');

    skincheck_db = @mongo_client['skincheck']
    skin_assessment_coll = skincheck_db['skinAssessment']
    skin_assessment_coll.remove(:patientIdentifier => patientId)
    now = Time.now
    for day in 3..5 do
      updateDate = prevAdmittedDateTime + (60 * 60 * 24 * day)
      assessmentHistory = assessment_history(patientId, updateDate, prevAdmittedDateTime)
      assessmentHistory = set_risk_education(assessmentHistory, updateDate, 3)
      skin_assessment_coll.insert(assessmentHistory)
    end

    skin_assessment_coll.find(:patientIdentifier => patientId).each { |doc|
      puts "inserted: #{doc}"
    }
  end

clear_and_generate_mongo_data_for_inpatient_eighty()
clear_and_generate_mongo_data_for_graphing_patient_one()